/*
 *  ClientDetailsForm.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Scene;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Pair;

public class ClientDetailsForm {

    private final Stage clientDetails = new Stage();
    private final MenuItem addClient;
    private static final Logger LOG = Logger.getLogger(ClientDetailsForm.class);
    public ClientDetailsForm(ClientSessionExecutor clientSessionExe, String css) {
        clientDetails.titleProperty().set("Client Details");
        addClient = new MenuItem("Client Details");
 
        BorderPane clientDetailsborder = new BorderPane();
        Scene clientDetailsScene = new Scene(clientDetailsborder, 300, 200);
        clientDetailsScene.getStylesheets().add(css);
        clientDetails.setScene(clientDetailsScene);

        addClient.setOnAction((ActionEvent t) -> {
            LOG.info("ClientDetailsMenuItem()");
            clientDetails.show();
            clientSessionExe.getClientData();
        });
    }

    public MenuItem getMenuItem() {
        return this.addClient;
    }

    public void update(List<Pair<String, String>> newData) {
        BorderPane bp = (BorderPane) clientDetails.sceneProperty().get().getRoot();
        bp.setLeft(GUIUtil.properties(newData));
    }
}
